const axios = require("axios");
const { v4: uuidv4 } = require('uuid');
/**
 * 请求参数 要求
 * url 
 * method  
 * headers  'Content-Type': 'application/json',
 * params  是与请求一起发送的 URL 参数
 * data
 * timeout
 * 
 * 返回参数 要求
 * code 成功时返回 0 ，失败时返回具体错误码
 * success 是否成功 
 * data 成功时具体返回值，失败时为 null
 * message 成功时返回 null ，失败时返回具体错误消息
 */
async function request(message) {
  try {
    const { url, method = "POST", headers = {}, params = {}, data = {}, timeout = 5 } = message;
    const response = await axios({
      method,
      url,
      params,
      data,
      timeout: timeout * 1000,
      headers: {
        'Content-Type': 'application/json',
        "X-Request-Id": uuidv4(),
        ...headers
      }
    });
    if (response.data.code !== 0) {
      throw new Error(response.data.message)
    }
  } catch (err) {
    console.log(err.message);
    throw new Error(err.message);
  }
}

module.exports = {
  request
}