const { createLogger, format, transports } = require('winston');
const getNamespace = require('cls-hooked').getNamespace;
const myFormat = format.printf(({ level, message, timestamp }) => {
  const loggerNamespace = getNamespace('logger');
  return `[${timestamp}] [${level}] ${loggerNamespace.get('requestId') ? ("[" + loggerNamespace.get('requestId') + "] :") : ''} ${message}`;
});

const logger = createLogger({
  level: 'info',
  format: format.combine(
    format.timestamp(),
    format.splat(),
    myFormat,
    format.json()
  ),
  transports: [
    new transports.Console(),
    new transports.File({
      dirname: './logs',
      filename: `test.log`,
    })
  ],
});

module.exports = logger;