import Router from 'koa-router'
const router = Router()
import { sendDelayMessage, sendRetryMessage } from "../utils/rabbitmq"
import { ok, error } from "../utils/system"
import { Message } from "../model/index"

router.post('/list', async (ctx, next) => {
  ctx.verifyParams({
    page: { type: 'int', required: false },
    limit: { type: 'int', required: false },
    filter: { type: 'object', required: false },
  })
  const { page = 1, limit = 10, filter = {} } = ctx.request.body;
  ctx.body = ok({
    list: await Message.find(filter, {}, {
      skip: (page - 1) * limit,
      limit,
      sort: {
        createdAt: -1
      }
    }),
    count: await Message.countDocuments(filter)
  })
})


/**
 * 发送消息 - 重试机制
 */
router.post('/sendRetryMessage', async (ctx, next) => {
  ctx.verifyParams({
    url: { type: 'string', required: true },
    method: { type: 'string', required: false },
    headers: { type: 'object', required: false },
    params: { type: 'object', required: false },
    data: { type: 'object', required: false },
    timeout: { type: 'int', required: false },
  })
  try {
    const result = await sendRetryMessage(ctx.request.body)
    ctx.body = ok(result)
  } catch (err) {
    ctx.body = error(err.message)
  }
})

/**
 * 发送消息 - 延时队列
 */
router.post('/sendDelayMessage', async (ctx, next) => {
  ctx.verifyParams({
    url: { type: 'string', required: true },
    method: { type: 'string', required: false },
    headers: { type: 'string', required: false },
    params: { type: 'object', required: false },
    data: { type: 'object', required: false },
    delayTime: { type: 'int', required: true },
    timeout: { type: 'int', required: false },
  })
  try {
    const result = await sendDelayMessage(ctx.request.body)
    ctx.body = ok(result)
  } catch (err) {
    ctx.body = error(err.message)
  }
})


module.exports = router
