const router = require('koa-router')()
const { sendDelayMessage, sendRetryMessage } = require("../utils/rabbitmq")
router.get('/', async (ctx, next) => {
  await ctx.render('index')
})

/**
 * 发送消息 - 重试机制
 */
router.post('/sendRetryMessage', async (ctx, next) => {
  ctx.verifyParams({
    url: { type: 'string', required: true },
    method: { type: 'string', required: false },
    headers: { type: 'object', required: false },
    params: { type: 'object', required: false },
    data: { type: 'object', required: false },
    timeout: { type: 'int', required: false },
  })
  ctx.body = await sendRetryMessage(ctx.request.body)
})

/**
 * 发送消息 - 延时队列
 */
router.post('/sendDelayMessage', async (ctx, next) => {
  ctx.verifyParams({
    url: { type: 'string', required: true },
    method: { type: 'string', required: false },
    headers: { type: 'string', required: false },
    params: { type: 'object', required: false },
    data: { type: 'object', required: false },
    delayTime: { type: 'int', required: true },
    timeout: { type: 'int', required: false },
  })
  ctx.body = await sendDelayMessage(ctx.request.body)
})


module.exports = router
