import Koa from 'koa';
const app = new Koa()
import views from 'koa-views'
import json from 'koa-json'
import onerror from 'koa-onerror'
import bodyparser from 'koa-bodyparser'
// import logger from 'koa-logger'
import parameter from 'koa-parameter'

import moment from "moment"
import rabbmitmqUtil from "./utils/rabbitmq"
rabbmitmqUtil.initQueue()
import correlation from './middleware/correlation'
import { createNamespace } from 'cls-hooked'

const logNameSpace = createNamespace('logger')

import index from './routes/index'
import test from './routes/test'

import logger from "./utils/logger"





// error handler
onerror(app)

// middlewares
app.use(bodyparser({
  enableTypes: ['json', 'form', 'text']
}))
app.use(parameter(app))
app.use(json())
// app.use(logger())
app.use(require('koa-static')(__dirname + '/public'))

app.use(views(__dirname + '/views', {
  extension: 'html'
}))

app.use(correlation(logNameSpace));


// logger
app.use(async (ctx, next) => {
  const start = new Date()
  await next()
  logger.info({
    request: ctx.request,
    response: ctx.body,
    useTime: new Date() - start
  })
})

// routes
app.use(index.routes(), index.allowedMethods())
app.use(test.routes(), test.allowedMethods())




// error-handling
app.on('error', (err, ctx) => {
  console.error('server error', err, ctx)
});

module.exports = app
