import { v4 as uuidv4 } from 'uuid';

function correlation(namespace) {
  return async (ctx, next) => {
    const requestId = ctx.header['x-request-id'] || uuidv4();
    namespace.run(async () => {
      namespace.set('requestId', requestId);
      await next();
    });
  }
}

export default correlation;