import axios from "axios"
import { v4 as uuidv4 } from 'uuid'
import { getNamespace } from 'cls-hooked';
import logger from "../utils/logger"


/**
 * 请求参数 要求
 * url 
 * method  
 * headers  'Content-Type': 'application/json',
 * params  是与请求一起发送的 URL 参数
 * data
 * timeout
 * 
 * 返回参数 要求
 * code 成功时返回 0 ，失败时返回具体错误码
 * success 是否成功 
 * data 成功时具体返回值，失败时为 null
 * message 成功时返回 null ，失败时返回具体错误消息
 */
export async function request(message) {
  const { url, method = "POST", headers = {}, params = {}, data = {}, timeout = 5 } = message;
  const start = new Date()
  try {
    const logNameSpace = getNamespace('logger');
    const response = await axios({
      method,
      url,
      params,
      data,
      timeout: timeout * 1000,
      headers: {
        'Content-Type': 'application/json',
        "X-Request-Id": (logNameSpace && logNameSpace.get("requestId")) || uuidv4(),
        ...headers
      }
    });
    if (response.data.code !== 0) {
      throw new Error(response.data.message)
    }
    logger.info({
      request: message,
      response: response.data,
      usedTime: new Date() - start,
      requestId: headers["X-Request-Id"]
    })
  } catch (err) {
    logger.error({
      request: message,
      response: err.message,
      usedTime: new Date() - start,
      requestId: headers["X-Request-Id"]
    })
    throw new Error(err.message);
  }
}