import amqp from 'amqplib';
import settings from "../settings"
const { MQ } = settings
import logger from "../utils/logger"

class RabbitmqClient {
  constructor() {
    this.socketOptions = MQ
    this.connnection = null;
    this.confirmChannel = null;
    this.channel = null;
  }

  async getConnnection() {
    try {
      if (!this.connnection) {
        const connnection = await amqp.connect(this.socketOptions);
        logger.info("--- MQ 连接 成功  ----")
        this.connnection = connnection;
        this.connnection.on("error", (err) => {
          logger.error("[x]Error:", err);
          this.connnection = null;
        });

        this.connnection.on("close", (err) => {
          logger.info("[x]Rabbitmq is closed ", err);
          this.connnection = null;
          process.exit(1)
        });
        process.once('SIGINT', this.connnection.close.bind(this.connnection));
      }
      return this.connnection;
    } catch (err) {
      logger.info("---  MQ 连接 失败 ------");
      logger.error(err);
      process.exit(1)
    }
  }

  async getConfirmChannel() {
    try {
      if (!this.confirmChannel) {
        const connnection = await this.getConnnection();
        const confirmChannel = await connnection.createConfirmChannel();
        this.confirmChannel = confirmChannel;
        this.confirmChannel.on("error", (err) => {
          logger.error("[x]Error", err);
          this.confirmChannel = null;
        });

        this.confirmChannel.on("close", (err) => {
          logger.info("[*]Rabbitmq channel is closed", err);
          this.confirmChannel = null;
        });
      }

      return this.confirmChannel;
    } catch (err) {
      logger.error("---  创建confirmChannel失败 ------");
      logger.error(err);
      throw new Error(err.message);
    }
  }

  async getChannel() {
    try {
      if (!this.channel) {
        const connnection = await this.getConnnection();
        const channel = await connnection.createChannel();
        this.channel = channel;
        this.channel.on("error", (err) => {
          logger.error("[x]Error", err);
          this.channel = null;
        });
        this.channel.on("close", (err) => {
          logger.info("[*]Rabbitmq channel is closed", err);
          this.channel = null;
        });
      }
      return this.channel;
    } catch (err) {
      logger.error("---  创建channe失败 ------");
      logger.error(err);
      throw new Error(err.message);
    }
  }
}
export default new RabbitmqClient();