
#### 测试环境地址
```
es   http://192.168.18.102:9200
kibana： http://192.168.18.102:5601
cerebro: http://192.168.18.102:3000
索引名： trademarkv2
字段 : {
  length:"总长度",
  cnlength:"中文长度",
  enlength:"英文长度",
  otherlength:"数字特殊符号长度",
  pinyin:"同音字设计",
   "name" : {
          "type" : "keyword",
          "fields" : {
            "all_pinyin" : { // 为同音字查询设计
              "type" : "text",
              "analyzer" : "all_pinyin"
            },
            "english" : {   // 为英文查询设计
              "type" : "text",
              "analyzer" : "english"
            },
            "jingque" : {     // 为精确查询设计 (包含繁体字大小写转换)
              "type" : "text",
              "analyzer" : "jingque"
            },
            "standard" : {
              "type" : "text",
              "analyzer" : "standard"
            },
            "tongyici" : { // 为同义词查询设计（用ik分词加同义词）
              "type" : "text",
              "analyzer" : "tongyici"
            },
            "xingjinzi" : {// 为形近字查询设计（用standard分词加同义词）
              "type" : "text",
              "analyzer" : "xingjinzi"
            }
          }
        }

}

``` 

近似搜索体验地址： http://192.168.18.101:3006/
#### 商标索引结构

```json
{
  "settings": {
    "number_of_shards": 1,
    "number_of_replicas": 0,
    "analysis": {
      "analyzer": {
        "shouzimu_pinyin": {
          "tokenizer": "shouzimu_pinyin"
        },
        "all_pinyin": {
          "tokenizer": "all_pinyin"
        },
        "xingjinzi": {
          "char_filter": [
            "fantizi"
          ],
          "tokenizer": "standard",
          "filter": [
            "lowercase",
            "xingjinzi"
          ]
        },
        "tongyici": {
          "char_filter": [
            "fantizi"
          ],
          "tokenizer": "ik_max_word",
          "filter": [
            "lowercase",
            "tongyici"
          ]
        },
        "jingque": {
          "char_filter": [
            "fantizi"
          ],
          "tokenizer": "keyword",
          "filter": [
            "lowercase"
          ]
        },
        "mypattern": {
          "char_filter": [
            "fantizi"
          ],
          "tokenizer": "mypattern",
          "filter": [
            "lowercase"
          ]
        }
      },
      "filter": {
        "xingjinzi": {
          "type": "synonym",
          "synonyms_path": "xingjinzi.txt"
        },
        "tongyici": {
          "type": "synonym",
          "synonyms_path": "tongyici.txt"
        }
      },
      "tokenizer": {
        "shouzimu_pinyin": {
          "type": "pinyin",
          "keep_first_letter": true,
          "keep_full_pinyin": false
        },
        "all_pinyin": {
          "type": "pinyin",
          "keep_first_letter": false,
          "keep_joined_full_pinyin": true,
          "keep_none_chinese_in_joined_full_pinyin": true
        },
        "mypattern": {
          "type": "pattern",
          "pattern": ","
        }
      },
      "char_filter": {
        "fantizi": {
          "type": "stconvert",
          "convert_type": "t2s"
        }
      }
    }
  },
  "mappings": {
    "properties": {
      "name": {
        "type": "keyword",
        "fields": {
          "standard": {
            "type": "text",
            "analyzer": "standard",
            "search_analyzer": "standard"
          },
          "jingque": {
            "type": "text",
            "analyzer": "jingque",
            "search_analyzer": "jingque"
          },
          "english": {
            "type": "text",
            "analyzer": "english",
            "search_analyzer": "english"
          },
          "all_pinyin": {
            "type": "text",
            "analyzer": "all_pinyin",
            "search_analyzer": "all_pinyin"
          },
          "xingjinzi": {
            "type": "text",
            "analyzer": "xingjinzi",
            "search_analyzer": "xingjinzi"
          },
          "tongyici": {
            "type": "text",
            "analyzer": "tongyici",
            "search_analyzer": "tongyici"
          }
        }
      },
      "length": {
        "type": "integer"
      },
      "cnlength": {
        "type": "integer"
      },
      "enlength": {
        "type": "integer"
      },
      "otherlength": {
        "type": "integer"
      },
      "pinyin":{
         "type": "keyword"
      }
    }
  }
}
```

#### 分词器的安装

##### ik分词

```
elasticsearch-plugin install https://github.com/medcl/elasticsearch-analysis-ik/releases/download/v7.13.1/elasticsearch-analysis-ik-7.13.1.zip

文档: https://github.com/medcl/elasticsearch-analysis-ik
```

##### 拼音分词器

```
elasticsearch-plugin install https://github.com/medcl/elasticsearch-analysis-pinyin/releases/download/v7.13.1/elasticsearch-analysis-pinyin-7.13.1.zip

文档 : https://github.com/medcl/elasticsearch-analysis-pinyin
```

##### 繁体字分词器

```
elasticsearch-plugin install https://github.com/medcl/elasticsearch-analysis-stconvert/releases/download/v7.13.1/elasticsearch-analysis-stconvert-7.13.1.zip
```

##### 词库

```
同义词、形近字 在 util文件下
```

#### 查询方法 

```
在 start.js里
```








