const mongoose = require('mongoose');
const config = {
  dbPath: "mongodb://192.168.18.101:27017/trademarkv1"
};

mongoose.set('debug', true)

mongoose.connect(config.dbPath, {
  useNewUrlParser: true,
  useUnifiedTopology: true,
  useCreateIndex: true
}, function (err) {
  if (err) {
    console.error(` MongoDB 连接失败  ${err.message} `);
    process.exit(1);
  }
})

mongoose.connection.on('disconnected', () => {

})
mongoose.connection.on('error', err => {
  console.error(err)
})

mongoose.connection.on('open', async () => {
  console.log('Connected to MongoDB ', config.dbPath)
})

module.exports = mongoose