const router = require('koa-router')()
const start = require("../startV1")
const es = require("../client/esclient");
router.get('/', async (ctx, next) => {
  await ctx.render('index')
})

router.post('/list', async (ctx, next) => {
  const { page, limit, conditions, name } = ctx.request.body;
  let query = await start(name, conditions)
  if (query.length > 0) {
    query = {
      query: {
        bool: {
          should: query
        }
      },
      "from": (page - 1) * limit,
      "size": limit,
    }
    console.log(JSON.stringify(query))
    const data = await es.search({
      index: "trademarkv3",
      body: query
    })
    const { body: { hits: { total, hits } } } = data;
    ctx.body = {
      list: hits.map(item => {
        return {
          name: item._source.name
        }
      }),
      count: total.value,
      query
    }
  } else {
    ctx.body = {
      list: [],
      count: 0,
      query
    }
  }
})

module.exports = router
