
// 加字词
const addString = "新,真,旧,早,红,亮,香,稳,热,喜,闹,急,多,少,高,矮,胖,瘦,漂亮,金黄,冷艳,动人,大,初级,高级,简单,复杂,细,长,短,很,非常,极,十分,最,顶,太,更,挺,极其,格外,分外,更加,越,越发,有点儿,稍,稍微,略微,几乎,过于,尤其,都,全,总,总共,共,统统,仅仅,只,光,净,一概,一律,一齐,单,已经,曾经,早已,刚刚,正,正在,就,就要,将,将要,曾,刚,才,在,马上,立刻,,渐渐,早晚,从来,终于,一向,向来,从来,总是,始终,往往,永,赶紧,仍然,还是,屡次,依然,重新,还,再,再三,偶尔,顿时,终于,常,常常,时常,时时,到处,处处,随处,四处,不,没,没有,不用(甭),必,必须,必定,准,的确,未,别,莫,勿,是否,不必,不曾,忽然,猛然,公然,特意,亲自,大肆,肆意,悄悄,连忙,赶紧,暗暗,难道,决,岂,反正,也许,大约,大概,果然,居然,竟然,究竟,幸而,幸亏,偏偏,明明,恰恰,未免,只好,不妨,索性,简直,就,可,难怪,反倒,何尝,何必,院,所,厂,部,行,局,司,署,厅,处,办,宫,园,馆,场,室,间,轩,屋,堂,斋,寨,庙,寺,观,村,镇,乡,府,庄,屯,港,岛,城,口,市,区,州,县,省,屿,站,岭,店,街,巷,里,都,楼,亭,堡,铺,湾,渡,社,营,洞,湖,集,坡,塔,阁,居,宫,源,校,斤,尺,亩,度,寸,米,尺,千克,克拉,吨,把,部,场,滴,顶,束,朵,副,个,根,间,件,棵,颗,口,块,粒,辆,片,扇,双,所,座,套,条,头,张,只,台,面,本,匹,尾,框,条,例,瓶,盒,杯,箱,桶,罐,群,束,方,园,正,酸,甜,苦,辣,咸,香,臭,麻,涩,鲜,红,橙,黄,绿,青,蓝,紫,黑,白,灰,棕,褐,金,银"
const xuci = "而,何,乎,乃,其,且,若 ,所,为,焉,也,以,因,于,与,则,者,之,卡,斯,特,尔,儿"

// 1. 完全相同
async function one(name, length, zhlength, enlength, otherlength, boost) {
  return {
    "must": [
      {
        "term": {
          "length": {
            "value": length
          }
        }
      },
      {
        bool: {
          should: [
            {
              "term": {
                "name": {
                  value: name,
                  "boost": boost
                },
              }
            },
            {
              "match": {
                "name.jingque": {
                  query: name,
                  "boost": boost
                },
              }
            }
          ]
        }
      }
    ]
  }
}

// 2. 完全相同加英文/图形符号，如：小米与小米A或A小米；（后缀—前缀）
async function two(name, length, zhlength, enlength, otherlength, boost) {
  return {
    must: [
      {
        range: {
          length: {
            gt: length
          }
        }
      }, {
        term: {
          cnlength: zhlength
        }
      },
      {
        "match_phrase": {
          "name.standard": {
            query: name,
            "boost": boost
          }
        }
      },
      {
        bool: {
          should: [
            {
              range: {
                enlength: {
                  gt: enlength
                }
              }
            }, {
              range: {
                otherlength: {
                  gt: otherlength
                }
              }
            }
          ]
        }
      }
    ]
  }
}

// 3. 倒序或倒序加英文/图形符号，如：小米与米小，全聚德与德聚全；小米与米小A或A米小；
async function three(name, length, zhlength, enlength, otherlength, boost) {
  return {
    should: [
      {
        bool: await one(name.split('').reverse().join(''), length, zhlength, enlength, otherlength, boost)
      },
      {
        bool: await two(name.split('').reverse().join(''), length, zhlength, enlength, otherlength, boost)
      }
    ]
  }
}

// 4.同音不同字或同音不同字加英文/图形符号，如：华为与铧为,华为与铧为A或A铧为；（同词加字母的组合展示）
async function four(name, length, zhlength, enlength, otherlength, boost) {
  return {
    should: [
      {
        bool: {
          "must": [
            {
              term: {
                length: {
                  value: length
                }
              }
            },
            {
              "match_phrase": {
                "name.all_pinyin": {
                  query: name,
                  "boost": boost
                },

              }
            }
          ],
          "must_not": [
            {
              "term": {
                "name.jingque": {
                  "value": name.toLowerCase()
                }
              }
            }
          ]
        }
      }, {
        bool: {
          "must": [
            {
              range: {
                length: {
                  gt: length
                }
              }
            },
            {
              term: {
                cnlength: zhlength
              }
            },
            {
              "match_phrase": {
                "name.all_pinyin": {
                  query: name,
                  "boost": boost

                },
              }
            },
            {
              bool: {
                should: [
                  {
                    range: {
                      enlength: {
                        gt: enlength
                      }
                    }
                  }, {
                    range: {
                      otherlength: {
                        gt: otherlength
                      }
                    }
                  }
                ]
              }
            }
          ],
          "must_not": [
            {
              match_phrase: {
                "name.standard": {
                  query: name
                }
              }
            }
          ]
        }
      }
    ]
  }
}

// 5. 同音不同字倒序或同音不同字倒序加英文/图形符号，如：华为与为铧或与为铧A或A为铧
async function five(name, length, zhlength, enlength, otherlength, boost) {
  return await four(name.split('').reverse().join(''), length, zhlength, enlength, otherlength, boost)
}

// 6. 完全相同后缀加字/词近似，如：小米与小米智慧或小米米等；
async function six(name, length, zhlength, enlength, otherlength, boost) {
  return {
    should: [
      {
        bool: {
          "must": [
            {
              "match": {
                "name.standard": {
                  "query": name,
                  "operator": "and",
                  "boost": boost
                }
              }
            },
            {
              "match": {
                "name.tongyici": {
                  "query": addString,
                  "analyzer": "mypattern",
                  "boost": boost
                }
              }
            },
            {
              "wildcard": {
                "name.jingque": {
                  "value": `${name.toLowerCase()}*`,
                  "boost": boost
                }
              }
            }
          ],
          "must_not": [
            {
              "term": {
                "name.jingque": {
                  "value": name.toLowerCase()
                }
              }
            }
          ]
        }
      },
      {
        bool: {
          "must": [
            {
              "match": {
                "name.standard": {
                  "query": name,
                  "operator": "and",
                  "boost": boost
                }
              }
            },
            {
              "wildcard": {
                "name.jingque": {
                  "value": `${name.toLowerCase()}*`,
                  "boost": boost
                }
              }
            }
          ],
          "must_not": [
            {
              "term": {
                "name.jingque": {
                  "value": name.toLowerCase()
                }
              }
            }
          ]
        }
      }
    ]
  }
}

//7. 完全相同前缀加字/词近似，如：小米与智慧小米或米小米等；
async function seven(name, length, zhlength, enlength, otherlength, boost) {
  return {
    should: [
      {
        bool: {
          "must": [
            {
              "match": {
                "name.standard": {
                  "query": name,
                  "operator": "and",
                  "boost": boost
                }
              }
            },
            {
              "match": {
                "name.tongyici": {
                  "query": addString,
                  "analyzer": "mypattern",
                  "boost": boost
                }
              }
            },
            {
              "wildcard": {
                "name.jingque": {
                  "value": `*${name.toLowerCase()}`,
                  "boost": boost
                }
              }
            }
          ],
          "must_not": [
            {
              "term": {
                "name.jingque": {
                  "value": name.toLowerCase()
                }
              }
            }
          ]
        }
      },
      {
        bool: {
          "must": [
            {
              "match": {
                "name.standard": {
                  "query": name,
                  "operator": "and",
                  "boost": boost
                }
              }
            },
            {
              "wildcard": {
                "name.jingque": {
                  "value": `*${name.toLowerCase()}`,
                  "boost": boost
                }
              }
            }
          ],
          "must_not": [
            {
              "term": {
                "name.jingque": {
                  "value": name.toLowerCase()
                }
              }
            }
          ]
        }
      }
    ]
  }
}

//8. 倒序后缀加字/词近似，如：华为与为华智慧或为华大等；
async function eight(name, length, zhlength, enlength, otherlength, boost) {
  return await six(name.split('').reverse().join(''), length, zhlength, enlength, otherlength, boost);
}

//9. 倒序前缀加字/词近似，如：华为与智慧为华或大为华等；
async function nine(name, length, zhlength, enlength, otherlength, boost) {
  return await seven(name.split('').reverse().join(''), length, zhlength, enlength, otherlength, boost);
}

//10. 相同词中加虚词或相同词中加虚词加英文/图形符号，如：小米与小之米或小之米A；
async function ten(name, length, zhlength, enlength, otherlength, boost) {
  return {
    should: [
      {
        bool: {
          must: [
            {
              "match": {
                "name.standard": {
                  "query": name,
                  "operator": "and",
                  "boost": boost
                }
              }
            },
            {
              match: {
                "name.standard": {
                  "query": xuci,
                  "boost": boost
                }
              }
            },
            {
              term: {
                cnlength: zhlength + 1
              }
            },
          ]
        }
      },
      {
        bool: {
          must: [
            {
              "match": {
                "name.standard": {
                  "query": name,
                  "operator": "and",
                  "boost": boost
                }
              }
            },
            {
              match: {
                "name.standard": {
                  "query": xuci,
                  "boost": boost
                }
              }
            },
            {
              term: {
                cnlength: zhlength + 1
              }
            },
            {
              range: {
                length: {
                  gt: length + 1
                }
              }
            }, {
              bool: {
                should: [
                  {
                    range: {
                      enlength: {
                        gt: enlength
                      }
                    }
                  }, {
                    range: {
                      otherlength: {
                        gt: otherlength
                      }
                    }
                  }
                ]
              }
            }
          ]
        }
      }
    ]
  }
}

//11. 商标文字含义相同/近似（也包含拼音/英文）
async function eleven(name, length, zhlength, enlength, otherlength, boost) {
  return {
    should: [
      {
        "bool": {
          "must": [
            {
              "match_phrase": {
                "name.tongyici": {
                  "query": name,
                  "boost": boost
                }
              }
            }
          ],
          "must_not": [
            {
              "term": {
                "name.jingque": {
                  "value": name.toLowerCase()
                }
              }
            }, {
              "wildcard": {
                "name.jingque": {
                  "value": `*${name.toLowerCase()}*`
                }
              }
            }
          ]
        }
      },
      {
        "bool": {
          "must": [
            {
              "match_phrase": {
                "name.english": {
                  "query": name,
                  "boost": boost
                }
              }
            }
          ],
          "must_not": [
            {
              "term": {
                "name.jingque": {
                  "value": name.toLowerCase()
                }
              }
            }, {
              "wildcard": {
                "name.jingque": {
                  "value": `*${name.toLowerCase()}*`
                }
              }
            }
          ]
        }
      }
    ]
  }
}

//12. 同字形不同音或同字形不同音加英文/图形符号，如：华为与毕为或毕为A;（先首字相同—换一个字—两个字—完全不同
async function twelve(name, length, zhlength, enlength, otherlength, boost) {
  return {
    should: [
      {
        "bool": {
          "must": [
            {
              "term": {
                "length": {
                  "value": length
                }
              }
            },
            {
              "match_phrase": {
                "name.standard": {
                  "analyzer": "xingjinzi",
                  "query": name,
                  "boost": boost
                }
              }
            }
          ],
          "must_not": [
            {
              "term": {
                "name.jingque": {
                  "value": name.toLowerCase()
                }
              }
            }
          ]
        }
      },
      {
        "bool": {
          "must": [
            {
              range: {
                length: {
                  gt: length
                }
              }
            }, {
              term: {
                cnlength: zhlength
              }
            },
            {
              "match_phrase": {
                "name.standard": {
                  "analyzer": "xingjinzi",
                  "query": name,
                  "boost": boost
                }
              }
            }, {
              bool: {
                should: [
                  {
                    range: {
                      enlength: {
                        gt: enlength
                      }
                    }
                  }, {
                    range: {
                      otherlength: {
                        gt: otherlength
                      }
                    }
                  }
                ]
              }
            }
          ],
          "must_not": [
            {
              match_phrase: {
                "name.standard": {
                  query: name
                }
              }
            }
          ]
        }
      }
    ]
  }
}

//13. 相同减字/词或相同减字/词加英文/图形符号，如：全聚德与全德或全德A；
async function thirteen(name, length, zhlength, enlength, otherlength, boost) {
  let array = [];
  for (let i = 0; i < length - 1; i++) {
    let query = {
      bool: {
        "must": [
          {
            "fuzzy": {
              "name.jingque": {
                "value": name.toLowerCase(),
                "fuzziness": i + 1,
                "max_expansions": 10000,
                "boost": boost
              }
            }
          }, {
            term: {
              length: length - i - 1
            }
          }
        ]
      }
    }
    array.push(query);
  }
  return {
    should: [
      ...array
    ]
  }
}

const funs = {
  1: one,
  2: two,
  3: three,
  4: four,
  5: five,
  6: six,
  7: seven,
  8: eight,
  9: nine,
  10: ten,
  11: eleven,
  12: twelve,
  13: thirteen
}
/**
 * 
 * @param {*} name 商标名
 * @param {*} conditions 查询条件
 */
async function start(name, conditions) {
  name = name.trim();
  const length = name.length;
  const zhlength = name.trim().replace(/[^\u4E00-\u9FA5]/g, '').length;
  const enlength = name.trim().replace(/[^a-zA-Z]/g, '').length;
  const otherlength = length - zhlength - enlength;
  let searchArry = [];
  let len = Object.keys(funs).length
  for (let val of conditions) {
    const query = await funs[val](name, length, zhlength, enlength, otherlength, Math.pow(10, len - val + 1));
    searchArry.push({
      bool: query
    })
  }
  return searchArry;
}

module.exports = start