const es = require("../client/esclient");
const { Name } = require("../model/index")
// 获取所有商标名
async function start() {
  let search_after = ['3.3490871E7']
  while (search_after && search_after.length > 0) {
    try {
      console.log(search_after)
      let data = await es.search({
        index: "bigdata_middle_gsb_tm_info",
        body: {
          "query": {
            "bool": {
              "must": [
                {
                  "exists": {
                    "field": "tm_name"
                  }
                }
              ],
              "must_not": [
                {
                  "term": {
                    "tm_name": "图形"
                  }
                }
              ]
            }
          },
          "_source": ["tm_name", "_id"],
          "search_after": search_after,
          "size": 10000,
          "sort": [
            {
              "_id": "asc"
            }
          ]
        }
      })
      let { body: { hits: { hits } } } = data;
      let array = [];
      for (let val of hits) {
        const { _source, sort } = val;
        if (_source.tm_name.trim()) {
          console.log(_source.tm_name, sort)
          array.push({ name: _source.tm_name });
          // try {
          //   await new Name().save({ name: _source.tm_name });
          // } catch (err) {
          //   console.log(err)
          // }
        }
      }
      try {
        await Name.insertMany(array, { ordered: false });
      } catch (err) {
        console.log(err)
      }
      if (hits.length <= 0) {
        search_after = false
      } else {
        let { _source, sort } = hits[hits.length - 1];
        search_after = sort
        console.log(search_after)
      }
    } catch (err) {
      console.log(err)
    }
  }
}
start()