const { Name } = require("../model/index");
const es = require("../client/esclient");
const { pinyin } = require('pinyin-pro');
/**
 * 往 es中 洗数据
 */
async function start() {
  let where = {
  }
  let i = 0;
  while (where) {
    try {
      const data = await Name.find(where).sort({ _id: 1 }).limit(10);
      if (data.length > 0) {
        let array = []
        console.log(i++)
        console.log("1:", data[0]._id)
        for (let val of data) {
          array.push({ "index": { "_index": "trademarkv3" } }, {
            name: val.name.trim(),
            length: val.name.trim().length,
            cnlength: val.name.trim().replace(/[^\u4E00-\u9FA5]/g, '').length,
            enlength: val.name.trim().replace(/[^a-zA-Z]/g, '').length,
            otherlength: val.name.trim().replace(/\s*/g, "").length - val.name.trim().replace(/[^\u4E00-\u9FA5]/g, '').length - val.name.trim().replace(/[^a-zA-Z]/g, '').length,
            pinyin: pinyin(val.name.trim(), { toneType: 'none' })
          })
        }
        await es.bulk({
          index: "trademarkv3",
          body: array
        })

        console.log("2:", data[data.length - 1]._id)
        where = {
          _id: {
            $gt: data[data.length - 1]._id
          }
        }
      } else {
        where = false
      }
    } catch (err) {
      console.log(err)
    }
  }
  console.log("结束")
}
start()


