const puppeteer = require('puppeteer');
const cheerio = require('cheerio');
const commonUtil = require("./common");
const fs = require("fs")
const os = require("os")
let fileName = "tongyici.txt"
// 获取同义词
async function start() {
  const browser = await puppeteer.launch({
    headless: false,
    slowMo: 100,
    ignoreDefaultArgs: ['--enable-automation'],
    args: [
      '--no-sandbox',
      '--disable-setuid-sandbox',
      '--disable-blink-features=AutomationControlled',
    ],
    dumpio: false,
  });
  const page = await browser.newPage();
  await commonUtil.anti_detection(page);
  await page.setViewport({
    width: 1920,
    height: 1080
  });
  await page.goto("https://xuewen.cnki.net/DetailList.aspx?code=&key=&bid=R201109323&cid=&type=&sort=0&otype=0&page=219");
  // 列表爬取
  let active = true;
  while (active) {
    await page.waitForSelector('.searchResultIfm');
    const html = await page.content();
    buildListData(html)
    // 解析 html
    active = await page.$('#apage_end');
    if (active) {
      await page.click('#apage_next');
      await page.waitForTimeout(1000);
    }
  }
}

function buildListData(html = '') {
  const $ = cheerio.load(html);
  let result = [];
  $(".title").each(function (item) {
    $(this).find('a').each(function () {
      console.log($(this).text().trim().split("——").join(","))
      fs.appendFileSync(fileName, $(this).text().trim().split("——").join(",") + os.EOL)
    })
  });
  return result
}

start()